<?php

require_once '../model/database.php';
require_once '../model/vendor_model.php';
require_once 'header.php';

$errors = [];
$inputData = [];

echo "<h1>Add New Vendor</h1>";
echo "<nav><a href='../index.php'>Home</a> | <a href='product_info.php'>Product Info</a> | <a href='manage_vendors.php'>Vendors</a></nav>";

if (isset($_POST['add'])) {
    $inputData = [
        'vend_name' => trim($_POST['vend_name']),
        'vend_address' => trim($_POST['vend_address']),
        'vend_city' => trim($_POST['vend_city']),
        'vend_state' => trim($_POST['vend_state']),
        'vend_zip' => trim($_POST['vend_zip']),
        'vend_country' => trim($_POST['vend_country'])
    ];

    // Validation   

    if (empty($inputData['vend_name'])) {
        $errors['vend_name'] = "Vendor Name is required.";
    } elseif (strlen($inputData['vend_name']) > 50) {
        $errors['vend_name'] = "Vendor Name cannot exceed 50 characters.";
    }

    if (empty($inputData['vend_address'])) {
        $errors['vend_address'] = "Vendor Address is required.";
    }

    if (empty($inputData['vend_city'])) {
        $errors['vend_city'] = "Vendor City is required.";
    }

    if (empty($inputData['vend_state'])) {
        $errors['vend_state'] = "Vendor State is required.";
    }

    if (empty($inputData['vend_zip'])) {
        $errors['vend_zip'] = "Vendor Zip Code is required.";
    } elseif (!is_numeric($inputData['vend_zip'])) {
        $errors['vend_zip'] = "Vendor Zip Code must be numeric.";
    }

    if (empty($inputData['vend_country'])) {
        $errors['vend_country'] = "Vendor Country is required.";
    }

    if (empty($errors)) {
        add_vendor($conn, $inputData['vend_name'], $inputData['vend_address'], $inputData['vend_city'], $inputData['vend_state'], $inputData['vend_zip'], $inputData['vend_country']);
        echo "<p>Vendor added successfully.</p>";
        echo "<a href='manage_vendors.php'>View Vendors</a>";
    } else {
        ?>
        <form method="post">
            
            <label>Vendor Name: <input type="text" name="vend_name" value="<?php echo htmlspecialchars($inputData['vend_name']); ?>">
                <?php if (isset($errors['vend_name'])) echo "<span class='error-msg'>" . $errors['vend_name'] . "</span>"; ?>
            </label><br>
            <label>Vendor Address: <input type="text" name="vend_address" value="<?php echo htmlspecialchars($inputData['vend_address']); ?>">
                <?php if (isset($errors['vend_address'])) echo "<span class='error-msg'>" . $errors['vend_address'] . "</span>"; ?>
            </label><br>
            <label>Vendor City: <input type="text" name="vend_city" value="<?php echo htmlspecialchars($inputData['vend_city']); ?>">
                <?php if (isset($errors['vend_city'])) echo "<span class='error-msg'>" . $errors['vend_city'] . "</span>"; ?>
            </label><br>
            <label>Vendor State: <input type="text" name="vend_state" value="<?php echo htmlspecialchars($inputData['vend_state']); ?>">
                <?php if (isset($errors['vend_state'])) echo "<span class='error-msg'>" . $errors['vend_state'] . "</span>"; ?>
            </label><br>
            <label>Vendor Zip: <input type="text" name="vend_zip" value="<?php echo htmlspecialchars($inputData['vend_zip']); ?>">
                <?php if (isset($errors['vend_zip'])) echo "<span class='error-msg'>" . $errors['vend_zip'] . "</span>"; ?>
            </label><br>
            <label>Vendor Country: <input type="text" name="vend_country" value="<?php echo htmlspecialchars($inputData['vend_country']); ?>">
                <?php if (isset($errors['vend_country'])) echo "<span class='error-msg'>" . $errors['vend_country'] . "</span>"; ?>
            </label><br>
            <input type="submit" name="add" value="Add Vendor">
        </form>
        <?php
    }
} else {
    ?>
    <form method="post">
        <label>Vendor Name: <input type="text" name="vend_name"></label><br>
        <label>Vendor Address: <input type="text" name="vend_address"></label><br>
        <label>Vendor City: <input type="text" name="vend_city"></label><br>
        <label>Vendor State: <input type="text" name="vend_state"></label><br>
        <label>Vendor Zip: <input type="text" name="vend_zip"></label><br>
        <label>Vendor Country: <input type="text" name="vend_country"></label><br>
        <input type="submit" name="add" value="Add Vendor">
    </form>
    <?php
}

require_once 'footer.php';
?>
